varying vec4 texcoord;
varying vec2 sunhide;
flat varying vec3 flareColor;

#include "/lib/sky_function.glsl"
float phaseg(float x, float g)
{
    float gg = g * g;
    return (gg * -0.25 + 0.25) * pow(-2.0 * (g * x) + (gg + 1.0), -1.5) / PI;
}

float NoisyStarField(in vec2 vSamplePos, float fThreshold)
{
    float StarVal =
        fract(dot(fract(vec3(vSamplePos.xyx) * 0.1031) +
                      dot(fract(vec3(vSamplePos.xyx) * 0.1031), fract(vec3(vSamplePos.xyx) * 0.1031).yzx + 19.19),
                  vec3(1.0)));

    StarVal = max(0.0, pow((abs(StarVal) - fThreshold) / (1.0 - fThreshold), 6.0));
    return clamp(StarVal, 0, 1);
}

float StableStarField(in vec2 vSamplePos, float fThreshold)
{
    float fractX = fract(vSamplePos.x);
    float fractY = fract(vSamplePos.y);
    vec2 floorSample = floor(vSamplePos);

    float v1 = NoisyStarField(floorSample, fThreshold);
    float v2 = NoisyStarField(floorSample + vec2(0.0, 1.0), fThreshold);
    float v3 = NoisyStarField(floorSample + vec2(1.0, 0.0), fThreshold);
    float v4 = NoisyStarField(floorSample + vec2(1.0, 1.0), fThreshold);

    float StarVal = mix(mix(v1, v2, fractY), mix(v3, v4, fractY), fractX);
    return StarVal;
}

float starsog(vec3 fragpos)
{
    float elevation = clamp(fragpos.y, 0, 1);
    vec2 uv = fragpos.xz / (1 + elevation);

    return (1 - nightblend5) * 4 * StableStarField(uv * 700, 0.999) * (0.3 - 0.3 * rainStrength);
}

float stars(vec3 fragpos)
{
    float elevation = clamp(fragpos.y, 0, 1);
    vec2 uv = fragpos.xz / (1 + elevation);

    return (1 - nightblend5) * 4 * StableStarField(uv * 700, 0.999) * (0.3 - 0.3 * rainStrength);
}

#if CLOUD_STYLE == 2
    #include "/lib/clouds/clouds_loop_a.glsl"
#else
    #include "/lib/clouds/clouds_bloop_a.glsl"
#endif

// https://software.intel.com/en-us/node/503873
vec3 RGB_YCoCg(vec3 c)
{
    // Y = R/4 + G/2 + B/4
    // Co = R/2 - B/2
    // Cg = -R/4 + G/2 - B/4
    return vec3(c.x / 4.0 + c.y / 2.0 + c.z / 4.0, c.x / 2.0 - c.z / 2.0, -c.x / 4.0 + c.y / 2.0 - c.z / 4.0);
}

float GetBorderFogMixFactor(in vec3 eyePlayerPos, in float far, in float z0)
{

    float eyeDist = length(eyePlayerPos);
    float borderFogFactor = smoothstep(far * 0.5, far, eyeDist);
    borderFogFactor *= borderFogFactor * borderFogFactor;
    return (eyeDist > far * 0.5) ? borderFogFactor : 0.0;
}
void main()
{
    /* DRAWBUFFERS:0 */
    vec3 np3 = vec3(vec2(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y) * (texcoord.xy * 2.0 - 1.0) +
                        gbufferProjectionInverse[3].xy,
                    1.0);
    np3 = vec3(np3.xy, gbufferProjectionInverse[3].z) / (gbufferProjectionInverse[2].w + gbufferProjectionInverse[3].w);
    np3 = mat3(gbufferModelViewInverse) * np3;
    np3 = normalize(np3);
    float z0 = texture(depthtex0, texcoord.xy).x;

    vec3 fragPos = toScreenSpace(vec3(texcoord.xy, z0));

    float borderFogFactor = GetBorderFogMixFactor(fragPos, far, 0.0);

    //  vec3 color = skyFromTex2((np3), colortex6).rgb + noise_standard(gl_FragCoord.xy) / 1024;
    vec4 skysample = texture(colortex0, texcoord.xy);
    vec3 color = skysample.rgb;
    vec4 cloud = vec4(0, 0, 0, 0);

    float noise = noise_standard(gl_FragCoord.xy);
    // if (z0 >= 1)
    {
#if CLOUD_STYLE == 2
        cloud = renderClouds(noise, np3, color, true);
#endif
#if CLOUD_STYLE == 1
        cloud = renderClouds(noise, np3, color, true);
#endif

        color *= cloud.a;

        color += cloud.rgb;

        color.rgb = Dither_Vlachos(color, 1024, gl_FragCoord.xy);
    }
    gl_FragData[0].rgb = vec3(color);
}
